--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination

fn ScriptID = 
(
    ""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
    ~CORONA_MATERIAL~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
    3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
    #(1891525894L, 1149841885L)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
    ~PHYSICAL_MATERIAL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
    3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
    #(0x3d6b1cecL, 0xdeadc001L) --Physical Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
( 
    local ret = false
    local src = SourceClassID()

    if(source == undefined) do return false

    if(classof src[1] == Array) then
    (
        for cd in src do
        (
            if((cd as string) == (source.ClassID as string)) do
            (
                ret = true
            )
        )
    )
    else
    (
        if((src as string) == (source.ClassID as string)) do
        (
            ret = true
        )
    )
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
    local ret = false
    local dest = DestinationClassID()

    if(destination == undefined) do return false

    if(classof dest[1] == Array) then
    (
        for cd in dest do
        (
            if((cd as string) == (destination.ClassID as string)) do
            (
                ret = true
            )
        )
    )
    else
    (
        if((dest as string) == (destination.ClassID as string)) do
        (
            ret = true
        )
    )
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
    ~ABOUT_TEXT~
)

fn getPropertyValue source prop =
(
	local ret = undefined
    ret = getProperty source prop
	ret
)

fn ApplyMultiplierToMap source  multiplier  basicColor = 
(
    local remap = OSLMap()
    remap.oslcode = "shader remap ( color In = 0.0, float multiplier = 1.0, color basicColor = 0.0, output color Out = 0.0 ) { Out = In * multiplier + (1 - multiplier)*basicColor; }"

    remap.In_map          =  source
    remap.multiplier      =  multiplier
    remap.basicColor      =  basicColor

    remap
)

--Internal function that does the parameter mapping
fn ConvertFrom_CoronaMtlToPhysical source dest =
(
    if ( false == VerifySource Source or 
         false == VerifyDestination Dest) do
    (
        --Not the suitable nodes
        return undefined
    )

    -- diffuse base parameters
    local colorDiffuse = getPropertyValue source "colorDiffuse"
    dest.base_color  = colorDiffuse

    if ((IsProperty colorDiffuse "controller") and (colorDiffuse.controller != undefined)) do (
        dest.base_color.controller = colorDiffuse.controller
    )

    local levelDiffuse = getPropertyValue source "levelDiffuse"
    dest.base_weight = levelDiffuse
    if ((IsProperty levelDiffuse "controller") and (levelDiffuse.controller != undefined)) do (
        dest.base_weight.controller = levelDiffuse.controller
    )

    dest.base_color_map_on    =    getPropertyValue source "texmapOnDiffuse"
    local texmapDiffuse = getPropertyValue source "texmapDiffuse"
    local texmapDiffuseAmount = getPropertyValue source "mapAmountDiffuse"
    texmapDiffuseAmount = texmapDiffuseAmount/100.0
    if((texmapDiffuse != undefined)  and (texmapDiffuseAmount != 1.0)) then 
    (
        dest.base_color_map       =   ApplyMultiplierToMap  texmapDiffuse  texmapDiffuseAmount  colorDiffuse
    )
    else
    (
        dest.base_color_map       =   texmapDiffuse 
    )

    if ((IsProperty texmapDiffuse "controller") and (texmapDiffuse.controller != undefined)) do (
        dest.base_color_map.controller    =    texmapDiffuse.controller
    )

    -- reflection properties
    local levelReflect = getPropertyValue source "levelReflect"
    dest.reflectivity       =   levelReflect
    if ((IsProperty levelReflect "controller") and (levelReflect.controller != undefined)) do (
        dest.reflectivity.controller    =    levelReflect.controller
    )

    dest.roughness_inv    =   true
    local reflectGlossiness = getPropertyValue source "reflectGlossiness"
    dest.roughness        =   reflectGlossiness
    if ((IsProperty reflectGlossiness "controller") and (reflectGlossiness.controller != undefined)) do (
        dest.roughness.controller = reflectGlossiness.controller
    )

    dest.roughness_map_on       =    getPropertyValue source "texmapOnReflectGlossiness"
    local texmapRoughness       =    getPropertyValue source "texmapReflectGlossiness"
    local texmapRoughnessAmount =    getPropertyValue source "mapamountReflectGlossiness"
    texmapRoughnessAmount       =    texmapRoughnessAmount/100.0
    if((texmapRoughness != undefined)  and (texmapRoughnessAmount != 1.0)) then 
    (
        local  reflectGlossColor  =  (color 255 255 255) * reflectGlossiness
        dest.roughness_map       =   ApplyMultiplierToMap  texmapRoughness  texmapRoughnessAmount  reflectGlossColor
    )
    else
    (
        dest.roughness_map       =   texmapRoughness 
    )

    local colorReflect = getPropertyValue source "colorReflect"
    dest.refl_color            =    colorReflect     --  Specular Color
    if ((IsProperty colorReflect "controller") and (colorReflect.controller != undefined)) do (
        dest.refl_color.controller = colorReflect.controller
    )

    dest.refl_color_map_on     =    getPropertyValue source "texmapOnReflect"   -- Specular color texture On/Off
    local texmapReflect        =    getPropertyValue source "texmapReflect"
    local texmapReflectAmount  =    getPropertyValue source "mapamountReflect"
    texmapReflectAmount        =    texmapReflectAmount/100.0
    if((texmapReflect != undefined)  and (texmapReflectAmount != 1.0)) then 
    (
        dest.refl_color_map       =   ApplyMultiplierToMap  texmapReflect  texmapReflectAmount  colorReflect
    )
    else
    (
        dest.refl_color_map       =   texmapReflect 
    )

    if(levelReflect  >  0.0) then
    (
        local fresnelIor = getPropertyValue source "fresnelIor"
        dest.trans_ior        =    fresnelIor
        if ((IsProperty fresnelIor "controller") and (fresnelIor.controller != undefined)) do (
            dest.trans_ior.controller = fresnelIor.controller
        )

        dest.trans_ior_map_on   =  getPropertyValue source "texmapOnFresnelIor"
        local texmapFresnelIor        =    getPropertyValue source "texmapFresnelIor"
        local texmapFresnelIorAmount  =    getPropertyValue source "mapamountFresnelIor"
        texmapFresnelIorAmount        =    texmapFresnelIorAmount/100.0
        if((texmapFresnelIor != undefined)  and (texmapFresnelIorAmount != 1.0)) then 
        (
            local  fresnelIorColor  =  (color 255 255 255) * fresnelIor
            dest.trans_ior_map       =   ApplyMultiplierToMap  texmapFresnelIor  texmapFresnelIorAmount  fresnelIorColor
        )
        else
        (
            dest.trans_ior_map       =   texmapFresnelIor 
        )
    )
    else
    (
        local ior = getPropertyValue source "ior"
        dest.trans_ior         =    ior
        if ((IsProperty ior "controller") and (ior.controller != undefined)) do (
            dest.trans_ior.controller = ior.controller
        )

        dest.trans_ior_map_on  =  getPropertyValue source "texmapOnIor"
        local texmapIor        =    getPropertyValue source "texmapIor"
        local texmapIorAmount  =    getPropertyValue source "mapamountIor"
        texmapIorAmount        =    texmapIorAmount/100.0
        if((texmapIor != undefined)  and (texmapIorAmount != 1.0)) then 
        (
            local  iorColor  =  (color 255 255 255) * ior
            dest.trans_ior_map       =   ApplyMultiplierToMapV2  texmapIor  texmapIorAmount  iorColor
        )
        else
        (
            dest.trans_ior_map       =   texmapFresnelIor 
        )
    )

    dest.brdf_mode  = true
    dest.material_mode = 1

    -- Refraction  properties
    local levelRefract = getPropertyValue source "levelRefract"
    dest.transparency      =    levelRefract
    if ((IsProperty levelRefract "controller") and (levelRefract.controller != undefined)) do (
        dest.transparency.controller    =    levelRefract.controller
    )

    local colorRefract = getPropertyValue source "colorRefract"
    dest.trans_color          =    colorRefract
    if ((IsProperty colorRefract "controller") and (colorRefract.controller != undefined)) do (
        dest.trans_color.controller = colorRefract.controller
    )

    dest.trans_color_map_on   =    getPropertyValue source "texmapOnRefract"
    local texmapRefract        =    getPropertyValue source "texmapRefract"
    local texmapRefractAmount  =    getPropertyValue source "mapamountRefract"
    texmapRefractAmount        =    texmapRefractAmount/100.0
    if((texmapRefract != undefined)  and (texmapRefractAmount != 1.0)) then 
    (
        dest.trans_color_map       =   ApplyMultiplierToMap  texmapRefract  texmapRefractAmount  colorRefract
    )
    else
    (
        dest.trans_color_map       =   texmapRefract 
    )

    dest.trans_roughness      =    getPropertyValue source "refractGlossiness"
    dest.trans_roughness_inv  =    true
    dest.trans_roughness_lock =    false

    dest.trans_rough_map_on        =    getPropertyValue source "texmapOnRefractGlossiness"
    local texmapRefractGloss       =    getPropertyValue source "texmapRefractGlossiness"
    local texmapRefractGlossAmount =    getPropertyValue source "mapamountRefractGlossiness"
    texmapRefractGlossAmount       =    texmapRefractGlossAmount/100.0
    if((texmapRefractGloss != undefined)  and (texmapRefractGlossAmount != 1.0)) then 
    (
        local  roughnessColor  =  (color 255 255 255) * dest.trans_roughness
        dest.trans_rough_map       =   ApplyMultiplierToMap  texmapRefractGloss  texmapRefractGlossAmount  roughnessColor
    )
    else
    (
        dest.trans_rough_map       =   texmapRefractGloss 
    )

    -- Translucency
    dest.thin_walled          =    getPropertyValue source "thin"

    local levelTranslucency = getPropertyValue source "levelTranslucency"
    dest.scattering           =    levelTranslucency
    if ((IsProperty levelTranslucency "controller") and (levelTranslucency.controller != undefined)) do (
        dest.scattering.controller    =    levelTranslucency.controller
    )

    local colorTranslucency   = getPropertyValue source "colorTranslucency"
    dest.sss_color            =    colorTranslucency
    if ((IsProperty colorTranslucency "controller") and (colorTranslucency.controller != undefined)) do (
        dest.sss_color.controller    =    colorTranslucency.controller
    )

    dest.sss_color_map_on          =    getPropertyValue source "texmapOnTranslucency"
    local texmapTranslucency       =    getPropertyValue source "texmapTranslucency"
    local texmapTranslucencyAmount =    getPropertyValue source "mapamountTranslucency"
    texmapTranslucencyAmount       =    texmapTranslucencyAmount/100.0
    if((texmapTranslucency != undefined)  and (texmapTranslucencyAmount != 1.0)) then 
    (
        dest.sss_color_map       =   ApplyMultiplierToMap  texmapTranslucency  texmapTranslucencyAmount  colorTranslucency
    )
    else
    (
        dest.sss_color_map       =   texmapTranslucency 
    )
 
    dest.scattering_map_on                 =    getPropertyValue source "texmapOnTranslucencyFraction"
    local texmapTranslucencyFraction       =    getPropertyValue source "texmapTranslucencyFraction"
    local texmapTranslucencyFractionAmount =    getPropertyValue source "mapamountTranslucencyFraction"
    texmapTranslucencyFractionAmount       =    texmapTranslucencyFractionAmount/100.0
    if((texmapTranslucencyFraction != undefined)  and (texmapTranslucencyFractionAmount != 1.0)) then 
    (
        local  levelColor  =  (color 255 255 255) * levelTranslucency
        dest.scattering_map       =   ApplyMultiplierToMap  texmapTranslucencyFraction  texmapTranslucencyFractionAmount  levelColor
    )
    else
    (
        dest.scattering_map       =   texmapTranslucencyFraction 
    )

    local levelTranslucency = getPropertyValue source "levelTranslucency"
    local texmapOnTranslucencyFraction = getPropertyValue source "texmapOnTranslucencyFraction"
    if(levelTranslucency > 0.0 or ( texmapOnTranslucencyFraction ==  true and texmapTranslucencyFraction != undefined)) do
    (
       dest.thin_walled      =  true     --  Translucency has to be enabled
    )

    local mediaMode = getPropertyValue source "mediaMode"
    if ( mediaMode == 1 ) then (   -- Volumetric Scattering
        local absorptionDistance = getPropertyValue source "absorptionDistance"
        local colorRefract = getPropertyValue source "colorRefract"
        local scatteringColor = getPropertyValue source "scatterColor"
        local absorptionColor = getPropertyValue source "absorptionColor"
        local texmapRefract = getPropertyValue source "texmapRefract"

       if (absorptionDistance > 0.0) do 
       (
           if(colorRefract  ==  (color 255 255 255)) then    
           (
               dest.trans_depth    =     absorptionDistance

               if(scatteringColor  ==  (color 0 0 0)) then
               (
                   dest.trans_color          =     absorptionColor  

                   if(texmapRefract == undefined) do
                   (
                       dest.trans_color_map_on   =    getPropertyValue source "texmapOnAbsorption"
                       local texmapAbsorption        =    getPropertyValue source "texmapAbsorption"
                       local texmapAbsorptionAmount  =    getPropertyValue source "mapamountAbsorption"
                       texmapAbsorptionAmount        =    texmapAbsorptionAmount/100.0
                       if((texmapAbsorption != undefined)  and (texmapAbsorptionAmount != 1.0)) then 
                       (
                           dest.trans_color_map       =   ApplyMultiplierToMap  texmapAbsorption  texmapAbsorptionAmount  absorptionColor
                       )
                       else
                       (
                           dest.trans_color_map       =   texmapAbsorption 
                       )
                   )
               )
               else
               (
                  -- Because we have a limited parameters to control refraction for physical material 
                  -- so we are not able to reproduce the effect when scatteringColor is not black

                  dest.trans_color    =     scatteringColor
               )
           ) 
           else
           (
                dest.trans_depth    =    0.0

                if(absorptionDistance < 1.0) do
                (
                    dest.trans_color.r    *=    absorptionDistance
                    dest.trans_color.g    *=    absorptionDistance
                    dest.trans_color.b    *=    absorptionDistance
                )
           )
       )
    ) else                                --   SSS
    (
        dest.scattering          =    getPropertyValue source "levelSss"
        dest.sss_depth           =    getPropertyValue source "sssRadius"
        dest.sss_color           =    getPropertyValue source "sssScatterColor"
        dest.sss_scatter_color   =    color 255 255 255 255
        dest.sss_scale           =    0.0

        dest.scattering_map_on   =    getPropertyValue source "texmapOnSssAmount"
        local texmapSssAmount    =    getPropertyValue source "texmapSssAmount"
        local mapamountSssAmount =    getPropertyValue source "mapamountSssAmount"
        mapamountSssAmount       =    mapamountSssAmount/100.0
        if((texmapSssAmount != undefined)  and (mapamountSssAmount != 1.0)) then 
        (
            local  scatteringColor  =  (color 255 255 255) * dest.scattering
            dest.scattering_map       =   ApplyMultiplierToMap  texmapSssAmount  mapamountSssAmount  scatteringColor
        )
        else
        (
            dest.scattering_map       =   texmapSssAmount 
        )

        dest.sss_color_map_on    =    getPropertyValue source "texmapOnSssScatterColor"
        local texmapSssScatterColor       =    getPropertyValue source "texmapSssScatterColor"
        local mapamountSssScatterColor =    getPropertyValue source "mapamountSssScatterColor"
        mapamountSssScatterColor       =    mapamountSssScatterColor/100.0
        if((texmapSssScatterColor != undefined)  and (mapamountSssScatterColor != 1.0)) then 
        (
            dest.sss_color_map       =   ApplyMultiplierToMap  texmapSssScatterColor  mapamountSssScatterColor  dest.sss_color
        )
        else
        (
            dest.sss_color_map       =   texmapSssScatterColor 
        )
    )


    -- Converts bump map
    dest.bump_map_on = getPropertyValue source "texmapOnBump"
    local texmapBump = getPropertyValue source "texmapBump"
    if (texmapBump != undefined) do 
    (
        dest.bump_map = texmapBump
        dest.bump_map_amt = getPropertyValue source "mapamountBump"
    )

    -- Converts displacement map

    dest.displacement_map_on     =    getPropertyValue source "texmapOnDisplacement"
    dest.displacement_map        =    getPropertyValue source "texmapDisplace"
    dest.displacement_map_amt    =    getPropertyValue source "displacementMaximum"

    -- Opacity
    local colorOpacity     =    getPropertyValue source "colorOpacity"
    dest.cutout_map_on     =    getPropertyValue source "texmapOnOpacity"
    local texmapOpacity    =    getPropertyValue source "texmapOpacity"
    local mapamountOpacity =    getPropertyValue source "mapamountOpacity"
    mapamountOpacity       =    mapamountOpacity/100.0
    if((texmapOpacity != undefined)  and (mapamountOpacity != 1.0)) then 
    (
        dest.cutout_map    =   ApplyMultiplierToMap  texmapOpacity  mapamountOpacity  colorOpacity
    )
    else
    (
        dest.cutout_map    =   texmapOpacity 
    )

    -- Emission
    dest.emission             =  getPropertyValue source "levelSelfIllum"
    dest.emit_color           =  getPropertyValue source "colorSelfIllum"
    local colorSelfIllum = getPropertyValue source "colorSelfIllum"
    if((IsProperty colorSelfIllum "controller") and (colorSelfIllum.controller != undefined)) do (
        dest.emit_color.controller   =   colorSelfIllum.controller
    )

    dest.emit_color_map_on     =  getPropertyValue source "texmapOnSelfIllum"
    local texmapSelfIllum    =    getPropertyValue source "texmapSelfIllum"
    local mapamountSelfIllum =    getPropertyValue source "mapamountSelfIllum"
    mapamountSelfIllum       =    mapamountSelfIllum/100.0
    if((texmapSelfIllum != undefined)  and (mapamountSelfIllum != 1.0)) then 
    (
        dest.emit_color_map    =   ApplyMultiplierToMap  texmapSelfIllum  mapamountSelfIllum  dest.emit_color
    )
    else
    (
        dest.emit_color_map    =   texmapSelfIllum 
    )

    -- Anisotropy
    local anisotropy = getPropertyValue source "anisotropy"
    if(anisotropy == 0.0) then
    (
       dest.anisotropy          =  1.0
    )
    else
    (
       dest.anisotropy          =  pow anisotropy 3.0
       dest.anisotropy          =  abs dest.anisotropy
    )

    if((IsProperty anisotropy "controller") and (anisotropy.controller != undefined)) do (
        dest.anisotropy.controller   =   anisotropy.controller
    )

    local anisotropyRotation = getPropertyValue source "anisotropyRotation"
    if(anisotropy > 0.0) then
    (
        local rotation_angle     =  abs(anisotropyRotation / 360.0) + 0.25
        dest.anisoangle          =  mod rotation_angle 1.0
    )
    else
    (
       dest.anisoangle          =  abs(anisotropyRotation / 360.0)
    )
    
    if((IsProperty anisotropyRotation "controller") and ( anisotropyRotation.controller != undefined)) do (
        dest.anisoangle.controller   =   anisotropyRotation.controller
    )

    dest.anisotropy_map_on   =  getPropertyValue source "texmapOnAnisotropy"
    local texmapReflectAnisotropy = getPropertyValue source "texmapReflectAnisotropy"
    if(texmapReflectAnisotropy  !=  undefined) do
    (
        local remap = OSLMap()
        remap.oslcode = "shader remap ( color In = 0.0, output color Out = 0.0 ) { Out = pow(In, 3.0); }"

        remap.In_map             =  texmapReflectAnisotropy
        dest.anisotropy_map      =  remap 
    )

    dest.aniso_angle_map_on  =  getPropertyValue source "texmapOnAnisotropyRotation"
    local texmapReflectAnisotropyRotation = getPropertyValue source "texmapReflectAnisotropyRotation"
    if (texmapReflectAnisotropyRotation != undefined) do
    (
        local remap = OSLMap()
        remap.oslcode = "shader remap ( color In = 0.0, output color Out = 0.0 ) { Out = 1.0 - In; }"

        remap.In_map             =  texmapReflectAnisotropyRotation
        dest.aniso_angle_map     =  remap 
    )

    dest.aniso_mode          =    getPropertyValue source "anisotropyOrientationMode"
    dest.aniso_channel       =    getPropertyValue source "anisotropyOrientationUvwChannel"

    dest
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case a default object is created and returned.
fn DefaultConversion source /*Not use*/=
(
    --Create the dest material
    newMat = PhysicalMaterial()

    --return the new material
    newMat

)

--Main entry point from this script
--This function handles the material's creation
fn Conversion coronaMtl =
(
    if (false == VerifySource coronaMtl )  do
    (
        --Not the suitable node
        return undefined
    )

    --Create the dest material
    newMat = PhysicalMaterial()

    --Call the parameters mapping function to convert
    ConvertFrom_CoronaMtlToPhysical coronaMtl newMat

    if (IsProperty coronaMtl "name") and (undefined != coronaMtl.name) and (String == classof coronaMtl.name)  and (IsProperty newMat "name") do
    (
        newMat.name = coronaMtl.name
    )

    --return the new material
    newMat
)
